<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["mo_master"] ) ) {
			$lookupTableLinks["mo_master"] = array();
		}
		if( !isset( $lookupTableLinks["mo_master"]["mo_details.mid"] )) {
			$lookupTableLinks["mo_master"]["mo_details.mid"] = array();
		}
		$lookupTableLinks["mo_master"]["mo_details.mid"]["edit"] = array("table" => "mo_details", "field" => "mid", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["mo_details.product_code"] )) {
			$lookupTableLinks["products"]["mo_details.product_code"] = array();
		}
		$lookupTableLinks["products"]["mo_details.product_code"]["edit"] = array("table" => "mo_details", "field" => "product_code", "page" => "edit");
		if( !isset( $lookupTableLinks["employers"] ) ) {
			$lookupTableLinks["employers"] = array();
		}
		if( !isset( $lookupTableLinks["employers"]["mo_details.related_person"] )) {
			$lookupTableLinks["employers"]["mo_details.related_person"] = array();
		}
		$lookupTableLinks["employers"]["mo_details.related_person"]["edit"] = array("table" => "mo_details", "field" => "related_person", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["mo_master.product_code"] )) {
			$lookupTableLinks["products"]["mo_master.product_code"] = array();
		}
		$lookupTableLinks["products"]["mo_master.product_code"]["edit"] = array("table" => "mo_master", "field" => "product_code", "page" => "edit");
		if( !isset( $lookupTableLinks["product_categories"] ) ) {
			$lookupTableLinks["product_categories"] = array();
		}
		if( !isset( $lookupTableLinks["product_categories"]["products.product_category"] )) {
			$lookupTableLinks["product_categories"]["products.product_category"] = array();
		}
		$lookupTableLinks["product_categories"]["products.product_category"]["add"] = array("table" => "products", "field" => "product_category", "page" => "add");
		if( !isset( $lookupTableLinks["unit"] ) ) {
			$lookupTableLinks["unit"] = array();
		}
		if( !isset( $lookupTableLinks["unit"]["products.unit"] )) {
			$lookupTableLinks["unit"]["products.unit"] = array();
		}
		$lookupTableLinks["unit"]["products.unit"]["edit"] = array("table" => "products", "field" => "unit", "page" => "edit");
		if( !isset( $lookupTableLinks["purchases"] ) ) {
			$lookupTableLinks["purchases"] = array();
		}
		if( !isset( $lookupTableLinks["purchases"]["purchase_details.purchase_id"] )) {
			$lookupTableLinks["purchases"]["purchase_details.purchase_id"] = array();
		}
		$lookupTableLinks["purchases"]["purchase_details.purchase_id"]["edit"] = array("table" => "purchase_details", "field" => "purchase_id", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["purchase_details.product_code"] )) {
			$lookupTableLinks["products"]["purchase_details.product_code"] = array();
		}
		$lookupTableLinks["products"]["purchase_details.product_code"]["edit"] = array("table" => "purchase_details", "field" => "product_code", "page" => "edit");
		if( !isset( $lookupTableLinks["supplier"] ) ) {
			$lookupTableLinks["supplier"] = array();
		}
		if( !isset( $lookupTableLinks["supplier"]["purchases.seller"] )) {
			$lookupTableLinks["supplier"]["purchases.seller"] = array();
		}
		$lookupTableLinks["supplier"]["purchases.seller"]["edit"] = array("table" => "purchases", "field" => "seller", "page" => "edit");
		if( !isset( $lookupTableLinks["purchases"] ) ) {
			$lookupTableLinks["purchases"] = array();
		}
		if( !isset( $lookupTableLinks["purchases"]["purchases.transport_by"] )) {
			$lookupTableLinks["purchases"]["purchases.transport_by"] = array();
		}
		$lookupTableLinks["purchases"]["purchases.transport_by"]["edit"] = array("table" => "purchases", "field" => "transport_by", "page" => "edit");
		if( !isset( $lookupTableLinks["sale_master"] ) ) {
			$lookupTableLinks["sale_master"] = array();
		}
		if( !isset( $lookupTableLinks["sale_master"]["sale_details.mid"] )) {
			$lookupTableLinks["sale_master"]["sale_details.mid"] = array();
		}
		$lookupTableLinks["sale_master"]["sale_details.mid"]["edit"] = array("table" => "sale_details", "field" => "mid", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["sale_details.product_code"] )) {
			$lookupTableLinks["products"]["sale_details.product_code"] = array();
		}
		$lookupTableLinks["products"]["sale_details.product_code"]["edit"] = array("table" => "sale_details", "field" => "product_code", "page" => "edit");
		if( !isset( $lookupTableLinks["customer1"] ) ) {
			$lookupTableLinks["customer1"] = array();
		}
		if( !isset( $lookupTableLinks["customer1"]["sale_master.buyer_code"] )) {
			$lookupTableLinks["customer1"]["sale_master.buyer_code"] = array();
		}
		$lookupTableLinks["customer1"]["sale_master.buyer_code"]["edit"] = array("table" => "sale_master", "field" => "buyer_code", "page" => "edit");
}

?>