<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["collections.loan_id"] )) {
			$lookupTableLinks["Loan Details"]["collections.loan_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["collections.loan_id"]["edit"] = array("table" => "collections", "field" => "loan_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["collections.customer_id"] )) {
			$lookupTableLinks["Loan Details"]["collections.customer_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["collections.customer_id"]["edit"] = array("table" => "collections", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Statistics"] ) ) {
			$lookupTableLinks["Statistics"] = array();
		}
		if( !isset( $lookupTableLinks["Statistics"]["loans.customer_id"] )) {
			$lookupTableLinks["Statistics"]["loans.customer_id"] = array();
		}
		$lookupTableLinks["Statistics"]["loans.customer_id"]["edit"] = array("table" => "loans", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["loan_settings"] ) ) {
			$lookupTableLinks["loan_settings"] = array();
		}
		if( !isset( $lookupTableLinks["loan_settings"]["loans.Loan"] )) {
			$lookupTableLinks["loan_settings"]["loans.Loan"] = array();
		}
		$lookupTableLinks["loan_settings"]["loans.Loan"]["edit"] = array("table" => "loans", "field" => "Loan", "page" => "edit");
		if( !isset( $lookupTableLinks["Statistics"] ) ) {
			$lookupTableLinks["Statistics"] = array();
		}
		if( !isset( $lookupTableLinks["Statistics"]["loans.guarantor_1"] )) {
			$lookupTableLinks["Statistics"]["loans.guarantor_1"] = array();
		}
		$lookupTableLinks["Statistics"]["loans.guarantor_1"]["edit"] = array("table" => "loans", "field" => "guarantor_1", "page" => "edit");
		if( !isset( $lookupTableLinks["Statistics"] ) ) {
			$lookupTableLinks["Statistics"] = array();
		}
		if( !isset( $lookupTableLinks["Statistics"]["loans.guarantor_2"] )) {
			$lookupTableLinks["Statistics"]["loans.guarantor_2"] = array();
		}
		$lookupTableLinks["Statistics"]["loans.guarantor_2"]["edit"] = array("table" => "loans", "field" => "guarantor_2", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["loans.Old_Loan"] )) {
			$lookupTableLinks["Loan Details"]["loans.Old_Loan"] = array();
		}
		$lookupTableLinks["Loan Details"]["loans.Old_Loan"]["edit"] = array("table" => "loans", "field" => "Old_Loan", "page" => "edit");
		if( !isset( $lookupTableLinks["Statistics"] ) ) {
			$lookupTableLinks["Statistics"] = array();
		}
		if( !isset( $lookupTableLinks["Statistics"]["loan_recovery.customer_id"] )) {
			$lookupTableLinks["Statistics"]["loan_recovery.customer_id"] = array();
		}
		$lookupTableLinks["Statistics"]["loan_recovery.customer_id"]["edit"] = array("table" => "Loan Recovery", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Statistics"] ) ) {
			$lookupTableLinks["Statistics"] = array();
		}
		if( !isset( $lookupTableLinks["Statistics"]["loan_recovery.guarantor_1"] )) {
			$lookupTableLinks["Statistics"]["loan_recovery.guarantor_1"] = array();
		}
		$lookupTableLinks["Statistics"]["loan_recovery.guarantor_1"]["edit"] = array("table" => "Loan Recovery", "field" => "guarantor_1", "page" => "edit");
		if( !isset( $lookupTableLinks["Statistics"] ) ) {
			$lookupTableLinks["Statistics"] = array();
		}
		if( !isset( $lookupTableLinks["Statistics"]["loan_recovery.guarantor_2"] )) {
			$lookupTableLinks["Statistics"]["loan_recovery.guarantor_2"] = array();
		}
		$lookupTableLinks["Statistics"]["loan_recovery.guarantor_2"]["edit"] = array("table" => "Loan Recovery", "field" => "guarantor_2", "page" => "edit");
		if( !isset( $lookupTableLinks["recovery"] ) ) {
			$lookupTableLinks["recovery"] = array();
		}
		if( !isset( $lookupTableLinks["recovery"]["loan_recovery.Old_Loan"] )) {
			$lookupTableLinks["recovery"]["loan_recovery.Old_Loan"] = array();
		}
		$lookupTableLinks["recovery"]["loan_recovery.Old_Loan"]["edit"] = array("table" => "Loan Recovery", "field" => "Old_Loan", "page" => "edit");
		if( !isset( $lookupTableLinks["project1ccc133_users"] ) ) {
			$lookupTableLinks["project1ccc133_users"] = array();
		}
		if( !isset( $lookupTableLinks["project1ccc133_users"]["project1ccc133_users.groupid"] )) {
			$lookupTableLinks["project1ccc133_users"]["project1ccc133_users.groupid"] = array();
		}
		$lookupTableLinks["project1ccc133_users"]["project1ccc133_users.groupid"]["edit"] = array("table" => "project1ccc133_users", "field" => "groupid", "page" => "edit");
		if( !isset( $lookupTableLinks["routes"] ) ) {
			$lookupTableLinks["routes"] = array();
		}
		if( !isset( $lookupTableLinks["routes"]["project1ccc133_users.route_id"] )) {
			$lookupTableLinks["routes"]["project1ccc133_users.route_id"] = array();
		}
		$lookupTableLinks["routes"]["project1ccc133_users.route_id"]["edit"] = array("table" => "project1ccc133_users", "field" => "route_id", "page" => "edit");
		if( !isset( $lookupTableLinks["expense_categories"] ) ) {
			$lookupTableLinks["expense_categories"] = array();
		}
		if( !isset( $lookupTableLinks["expense_categories"]["expenses.category"] )) {
			$lookupTableLinks["expense_categories"]["expenses.category"] = array();
		}
		$lookupTableLinks["expense_categories"]["expenses.category"]["edit"] = array("table" => "expenses", "field" => "category", "page" => "edit");
		if( !isset( $lookupTableLinks["expense_categories"] ) ) {
			$lookupTableLinks["expense_categories"] = array();
		}
		if( !isset( $lookupTableLinks["expense_categories"]["expenses.details"] )) {
			$lookupTableLinks["expense_categories"]["expenses.details"] = array();
		}
		$lookupTableLinks["expense_categories"]["expenses.details"]["edit"] = array("table" => "expenses", "field" => "details", "page" => "edit");
		if( !isset( $lookupTableLinks["expense_categories"] ) ) {
			$lookupTableLinks["expense_categories"] = array();
		}
		if( !isset( $lookupTableLinks["expense_categories"]["expense_categories.category_name"] )) {
			$lookupTableLinks["expense_categories"]["expense_categories.category_name"] = array();
		}
		$lookupTableLinks["expense_categories"]["expense_categories.category_name"]["edit"] = array("table" => "expense_categories", "field" => "category_name", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["collections1.loan_id"] )) {
			$lookupTableLinks["Loan Details"]["collections1.loan_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["collections1.loan_id"]["edit"] = array("table" => "collections1", "field" => "loan_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["collections_report.loan_id"] )) {
			$lookupTableLinks["Loan Details"]["collections_report.loan_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["collections_report.loan_id"]["search"] = array("table" => "collections Report", "field" => "loan_id", "page" => "search");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["collections_report.customer_id"] )) {
			$lookupTableLinks["Loan Details"]["collections_report.customer_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["collections_report.customer_id"]["search"] = array("table" => "collections Report", "field" => "customer_id", "page" => "search");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["collections_collecters.loan_id"] )) {
			$lookupTableLinks["Loan Details"]["collections_collecters.loan_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["collections_collecters.loan_id"]["edit"] = array("table" => "collections_collecters", "field" => "loan_id", "page" => "edit");
		if( !isset( $lookupTableLinks["routes"] ) ) {
			$lookupTableLinks["routes"] = array();
		}
		if( !isset( $lookupTableLinks["routes"]["rout_plans.route_id"] )) {
			$lookupTableLinks["routes"]["rout_plans.route_id"] = array();
		}
		$lookupTableLinks["routes"]["rout_plans.route_id"]["edit"] = array("table" => "rout_plans", "field" => "route_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["rout_plans.Loan Details"] )) {
			$lookupTableLinks["Loan Details"]["rout_plans.Loan Details"] = array();
		}
		$lookupTableLinks["Loan Details"]["rout_plans.Loan Details"]["edit"] = array("table" => "rout_plans", "field" => "Loan Details", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["rout_plans.Name"] )) {
			$lookupTableLinks["Loan Details"]["rout_plans.Name"] = array();
		}
		$lookupTableLinks["Loan Details"]["rout_plans.Name"]["edit"] = array("table" => "rout_plans", "field" => "Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["rout_plans.Loan No"] )) {
			$lookupTableLinks["Loan Details"]["rout_plans.Loan No"] = array();
		}
		$lookupTableLinks["Loan Details"]["rout_plans.Loan No"]["edit"] = array("table" => "rout_plans", "field" => "Loan No", "page" => "edit");
		if( !isset( $lookupTableLinks["loandata"] ) ) {
			$lookupTableLinks["loandata"] = array();
		}
		if( !isset( $lookupTableLinks["loandata"]["rout_plans.Arrears Amount"] )) {
			$lookupTableLinks["loandata"]["rout_plans.Arrears Amount"] = array();
		}
		$lookupTableLinks["loandata"]["rout_plans.Arrears Amount"]["edit"] = array("table" => "rout_plans", "field" => "Arrears Amount", "page" => "edit");
		if( !isset( $lookupTableLinks["routes"] ) ) {
			$lookupTableLinks["routes"] = array();
		}
		if( !isset( $lookupTableLinks["routes"]["my_route.route_id"] )) {
			$lookupTableLinks["routes"]["my_route.route_id"] = array();
		}
		$lookupTableLinks["routes"]["my_route.route_id"]["edit"] = array("table" => "My route", "field" => "route_id", "page" => "edit");
		if( !isset( $lookupTableLinks["loandata"] ) ) {
			$lookupTableLinks["loandata"] = array();
		}
		if( !isset( $lookupTableLinks["loandata"]["my_route.Loan Details"] )) {
			$lookupTableLinks["loandata"]["my_route.Loan Details"] = array();
		}
		$lookupTableLinks["loandata"]["my_route.Loan Details"]["edit"] = array("table" => "My route", "field" => "Loan Details", "page" => "edit");
		if( !isset( $lookupTableLinks["loandata"] ) ) {
			$lookupTableLinks["loandata"] = array();
		}
		if( !isset( $lookupTableLinks["loandata"]["my_route.Name"] )) {
			$lookupTableLinks["loandata"]["my_route.Name"] = array();
		}
		$lookupTableLinks["loandata"]["my_route.Name"]["edit"] = array("table" => "My route", "field" => "Name", "page" => "edit");
		if( !isset( $lookupTableLinks["loandata"] ) ) {
			$lookupTableLinks["loandata"] = array();
		}
		if( !isset( $lookupTableLinks["loandata"]["my_route.Arrears Amount"] )) {
			$lookupTableLinks["loandata"]["my_route.Arrears Amount"] = array();
		}
		$lookupTableLinks["loandata"]["my_route.Arrears Amount"]["edit"] = array("table" => "My route", "field" => "Arrears Amount", "page" => "edit");
		if( !isset( $lookupTableLinks["expense_categories"] ) ) {
			$lookupTableLinks["expense_categories"] = array();
		}
		if( !isset( $lookupTableLinks["expense_categories"]["expenses_report.category"] )) {
			$lookupTableLinks["expense_categories"]["expenses_report.category"] = array();
		}
		$lookupTableLinks["expense_categories"]["expenses_report.category"]["search"] = array("table" => "expenses Report", "field" => "category", "page" => "search");
		if( !isset( $lookupTableLinks["expense_categories"] ) ) {
			$lookupTableLinks["expense_categories"] = array();
		}
		if( !isset( $lookupTableLinks["expense_categories"]["expenses_report.details"] )) {
			$lookupTableLinks["expense_categories"]["expenses_report.details"] = array();
		}
		$lookupTableLinks["expense_categories"]["expenses_report.details"]["search"] = array("table" => "expenses Report", "field" => "details", "page" => "search");
		if( !isset( $lookupTableLinks["Loan Details"] ) ) {
			$lookupTableLinks["Loan Details"] = array();
		}
		if( !isset( $lookupTableLinks["Loan Details"]["my_collections.loan_id"] )) {
			$lookupTableLinks["Loan Details"]["my_collections.loan_id"] = array();
		}
		$lookupTableLinks["Loan Details"]["my_collections.loan_id"]["edit"] = array("table" => "My collections", "field" => "loan_id", "page" => "edit");
}

?>